const vuedraggable = resolve => import('vuedraggable').then((res)=>resolve(res));

/* Makes an empty Vue component to use in IE. Since draggable functionality crashes IE */
var isIE = /MSIE|Trident/.test(window.navigator.userAgent);

const draggable = isIE ? {
  data: function () {
    return {
    }
  },
  template: '<div><slot></slot></div>'
} : vuedraggable;

var script = {
	components: {
		draggable,
	},
	data() {
		return {};
	},
};

/* script */
            const __vue_script__ = script;
            
/* template */
var __vue_render__ = function() {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "wizdomWebpart",
    {
      attrs: {
        environmentInfo: _vm.environmentInfo,
        chromeProperties: _vm.webpartProperties.chromeProperties,
        title: _vm._f("translate")("FAQ"),
        webpartPadding: true,
        paddingTop: 10,
        paddingSides: 0,
        chromeType: "visual"
      },
      on: {
        titleChanged: function($event) {
          _vm.webpartProperties.title = $event;
        },
        "webpart-resize": _vm.webpartResize
      }
    },
    [
      _c(
        "div",
        { staticClass: "faq-container" },
        [
          _vm.environmentInfo.isEditMode && !_vm.webpartProperties.useGlobalSet
            ? _c("div", { staticClass: "edit" }, [
                _vm.environmentInfo.isEditMode &&
                !_vm.webpartProperties.useGlobalSet
                  ? _c(
                      "span",
                      {
                        staticClass: "edit-item",
                        on: {
                          click: function($event) {
                            return _vm.categoryEdit()
                          }
                        }
                      },
                      [
                        _c("uiIconAdd", { staticClass: "header-icon" }),
                        _vm._v(
                          "\r\n\t\t\t\t" +
                            _vm._s(_vm._f("translate")("Create category")) +
                            "\r\n\t\t\t"
                        )
                      ],
                      1
                    )
                  : _vm._e()
              ])
            : _vm._e(),
          _vm._v(" "),
          _c(
            "draggable",
            {
              attrs: {
                list: _vm.faqCategories,
                options: {
                  draggable: ".draggableCategory",
                  group: "categories",
                  disabled:
                    !_vm.environmentInfo.isEditMode ||
                    _vm.webpartProperties.useGlobalSet
                },
                handle: ".categoryHandle",
                "ghost-class": "categoryGhost"
              },
              on: {
                start: function($event) {
                  _vm.drag = true;
                },
                end: function($event) {
                  _vm.drag = false;
                },
                change: function($event) {
                  return _vm.orderChanged()
                }
              }
            },
            _vm._l(_vm.visibleCategories, function(category) {
              return (!_vm.environmentInfo.isEditMode &&
                category.questions.length >= 1) ||
                _vm.environmentInfo.isEditMode
                ? _c(
                    "div",
                    {
                      key: category.id,
                      staticClass: "link-collection-content",
                      class: {
                        draggableCategory: _vm.environmentInfo.isEditMode
                      }
                    },
                    [
                      _c(
                        "div",
                        { staticClass: "panel" },
                        [
                          !(
                            _vm.getCategories.length == 1 &&
                            _vm.getCategories[0].isRoot
                          ) || _vm.environmentInfo.isEditMode
                            ? _c("div", { staticClass: "panel-heading" }, [
                                _c("div", { staticClass: "panel-title" }, [
                                  !category.isRoot
                                    ? _c("span", [
                                        _vm._v(_vm._s(category.title))
                                      ])
                                    : _vm._e(),
                                  _vm._v(" "),
                                  category.isRoot
                                    ? _c("span", [
                                        _vm._v(
                                          _vm._s(
                                            _vm._f("translate")("Uncategorized")
                                          )
                                        )
                                      ])
                                    : _vm._e(),
                                  _vm._v(" "),
                                  _vm.environmentInfo.isEditMode &&
                                  !_vm.webpartProperties.useGlobalSet
                                    ? _c(
                                        "span",
                                        { staticClass: "categoryAction" },
                                        [
                                          _c("uiIconMove", {
                                            staticClass: "categoryHandle"
                                          }),
                                          _vm._v(" "),
                                          !category.isRoot
                                            ? _c("uiIconDelete", {
                                                on: {
                                                  click: function($event) {
                                                    _vm.deleteDialogData = {
                                                      category: category
                                                    };
                                                  }
                                                }
                                              })
                                            : _vm._e(),
                                          _vm._v(" "),
                                          !category.isRoot
                                            ? _c("uiIconEdit", {
                                                on: {
                                                  click: function($event) {
                                                    _vm.categoryEditItem = category;
                                                  }
                                                }
                                              })
                                            : _vm._e(),
                                          _vm._v(" "),
                                          _c("uiIconAdd", {
                                            on: {
                                              click: function($event) {
                                                return _vm.questionCreate(
                                                  category
                                                )
                                              }
                                            }
                                          })
                                        ],
                                        1
                                      )
                                    : _vm._e()
                                ])
                              ])
                            : _vm._e(),
                          _vm._v(" "),
                          _c(
                            "draggable",
                            {
                              staticClass: "list-group",
                              attrs: {
                                tag: "ul",
                                options: {
                                  draggable: ".draggableQuestion",
                                  group: "questions",
                                  disabled:
                                    !_vm.environmentInfo.isEditMode ||
                                    _vm.webpartProperties.useGlobalSet
                                },
                                handle: ".questionHandle",
                                "ghost-class": "questionGhost"
                              },
                              on: {
                                start: function($event) {
                                  _vm.drag = true;
                                },
                                end: function($event) {
                                  _vm.drag = false;
                                },
                                change: function($event) {
                                  return _vm.orderChanged()
                                }
                              },
                              model: {
                                value: category.questions,
                                callback: function($$v) {
                                  _vm.$set(category, "questions", $$v);
                                },
                                expression: "category.questions"
                              }
                            },
                            _vm._l(category.questions, function(question) {
                              return _c(
                                "li",
                                {
                                  directives: [
                                    {
                                      name: "show",
                                      rawName: "v-show",
                                      value:
                                        question.isTopFAQ || category.showAll,
                                      expression:
                                        "question.isTopFAQ || category.showAll"
                                    }
                                  ],
                                  key: question.id,
                                  staticClass: "list-group-item",
                                  class: {
                                    draggableQuestion:
                                      _vm.environmentInfo.isEditMode
                                  }
                                },
                                [
                                  _c(
                                    "div",
                                    {
                                      staticClass: "question",
                                      on: {
                                        click: function($event) {
                                          return _vm.showTheAnswer(question)
                                        }
                                      }
                                    },
                                    [
                                      _c("wizdom365Icon", {
                                        staticClass: "questionIcon",
                                        attrs: { icon: question.modernIcon }
                                      }),
                                      _vm._v(" "),
                                      _c(
                                        "span",
                                        {
                                          class: {
                                            questionTextEdit:
                                              _vm.environmentInfo.isEditMode,
                                            questionTextView: !_vm
                                              .environmentInfo.isEditMode
                                          }
                                        },
                                        [_vm._v(_vm._s(question.question))]
                                      ),
                                      _vm._v(" "),
                                      _c(
                                        "div",
                                        { staticClass: "questionAction" },
                                        [
                                          _vm.environmentInfo.isEditMode &&
                                          !_vm.webpartProperties.useGlobalSet
                                            ? _c(
                                                "span",
                                                [
                                                  _c("uiIconMove", {
                                                    staticClass:
                                                      "questionHandle"
                                                  }),
                                                  _vm._v(" "),
                                                  _c("uiIconDelete", {
                                                    nativeOn: {
                                                      click: function($event) {
                                                        $event.stopPropagation();
                                                        _vm.deleteDialogData = {
                                                          question: question,
                                                          category: category
                                                        };
                                                      }
                                                    }
                                                  }),
                                                  _vm._v(" "),
                                                  _c("uiIconEdit", {
                                                    nativeOn: {
                                                      click: function($event) {
                                                        $event.stopPropagation();
                                                        return _vm.questionEdit(
                                                          question,
                                                          category
                                                        )
                                                      }
                                                    }
                                                  })
                                                ],
                                                1
                                              )
                                            : _vm._e(),
                                          _vm._v(" "),
                                          _c("uiIconChevronDownMed", {
                                            directives: [
                                              {
                                                name: "show",
                                                rawName: "v-show",
                                                value: !question.showAnswer,
                                                expression:
                                                  "!question.showAnswer"
                                              }
                                            ]
                                          }),
                                          _vm._v(" "),
                                          _c("uiIconChevronUpMed", {
                                            directives: [
                                              {
                                                name: "show",
                                                rawName: "v-show",
                                                value: question.showAnswer,
                                                expression:
                                                  "question.showAnswer"
                                              }
                                            ]
                                          })
                                        ],
                                        1
                                      )
                                    ],
                                    1
                                  ),
                                  _vm._v(" "),
                                  _c(
                                    "div",
                                    { staticClass: "answer" },
                                    [
                                      _c(
                                        "transition",
                                        {
                                          key: question.id,
                                          attrs: { name: "slide-down" }
                                        },
                                        [
                                          _c(
                                            "div",
                                            {
                                              directives: [
                                                {
                                                  name: "show",
                                                  rawName: "v-show",
                                                  value: question.showAnswer,
                                                  expression:
                                                    "question.showAnswer"
                                                }
                                              ],
                                              staticClass: "question-content"
                                            },
                                            [
                                              _c("div", {
                                                attrs: {
                                                  id: "row_" + question.id
                                                },
                                                domProps: {
                                                  innerHTML: _vm._s(
                                                    question.answer
                                                  )
                                                }
                                              })
                                            ]
                                          )
                                        ]
                                      )
                                    ],
                                    1
                                  )
                                ]
                              )
                            }),
                            0
                          ),
                          _vm._v(" "),
                          _c(
                            "div",
                            {
                              directives: [
                                {
                                  name: "show",
                                  rawName: "v-show",
                                  value: category.showShowAllButton,
                                  expression: "category.showShowAllButton"
                                }
                              ],
                              staticClass: "text-center faqShowAllButton",
                              on: {
                                click: function($event) {
                                  category.showAll = !category.showAll;
                                }
                              }
                            },
                            [
                              _c("a", [
                                !category.showAll
                                  ? _c("span", [
                                      _vm._v(
                                        _vm._s(
                                          _vm._f("translate")(
                                            "Show all questions"
                                          )
                                        )
                                      )
                                    ])
                                  : _vm._e(),
                                _vm._v(" "),
                                category.showAll
                                  ? _c("span", [
                                      _vm._v(
                                        _vm._s(
                                          _vm._f("translate")(
                                            "Show only top questions"
                                          )
                                        )
                                      )
                                    ])
                                  : _vm._e()
                              ])
                            ]
                          )
                        ],
                        1
                      )
                    ]
                  )
                : _vm._e()
            }),
            0
          ),
          _vm._v(" "),
          _vm.getCategories && _vm.getCategories.length > _vm.pagesize
            ? _c("pagination", {
                staticClass: "pagination",
                attrs: {
                  pageSize: _vm.pagesize,
                  align: "center",
                  length: _vm.getCategories.length,
                  webpartSize: _vm.webpartSize
                },
                on: { onPageChanged: _vm.pageChanged },
                model: {
                  value: _vm.currentPage,
                  callback: function($$v) {
                    _vm.currentPage = $$v;
                  },
                  expression: "currentPage"
                }
              })
            : _vm._e()
        ],
        1
      ),
      _vm._v(" "),
      _vm.categoryEditItem
        ? _c("categoryPanel", {
            on: {
              categoryCreated: _vm.categoryCreated,
              categoryUpdated: _vm.categoryUpdated
            },
            model: {
              value: _vm.categoryEditItem,
              callback: function($$v) {
                _vm.categoryEditItem = $$v;
              },
              expression: "categoryEditItem"
            }
          })
        : _vm._e(),
      _vm._v(" "),
      _vm.questionEditItem
        ? _c("questionPanel", {
            on: {
              questionCreated: _vm.questionCreated,
              questionUpdated: _vm.questionUpdated
            },
            model: {
              value: _vm.questionEditItem,
              callback: function($$v) {
                _vm.questionEditItem = $$v;
              },
              expression: "questionEditItem"
            }
          })
        : _vm._e(),
      _vm._v(" "),
      _vm.deleteDialogData
        ? _c("deleteConfirmationDialog", {
            attrs: { deleteDialogData: _vm.deleteDialogData },
            on: {
              deleteCategory: function($event) {
                return _vm.categoryDelete(_vm.deleteDialogData.category)
              },
              deleteQuestion: function($event) {
                return _vm.questionDelete(
                  _vm.deleteDialogData.question,
                  _vm.deleteDialogData.category
                )
              },
              deleteDialogClosed: _vm.deleteDialogClosedEvent
            }
          })
        : _vm._e()
    ],
    1
  )
};
var __vue_staticRenderFns__ = [];
__vue_render__._withStripped = true;

  /* style */
  const __vue_inject_styles__ = function (inject) {
    if (!inject) return
    inject("data-v-4e88244e_0", { source: ".faq-container[data-v-4e88244e] {\n  color: \"[theme:neutralPrimary, default: #333333]\";\n  padding-left: 0px;\n  padding-right: 0px;\n}\n.faq-container .edit[data-v-4e88244e] {\n    display: inline-block;\n    margin: 0px 0 15px 0;\n}\n.faq-container .edit .ms-Icon[data-v-4e88244e] {\n      position: relative;\n      top: 2px;\n      margin-right: 6px;\n}\n.faq-container .edit .edit-item[data-v-4e88244e] {\n      cursor: pointer;\n}\n.faq-container .categoryAction[data-v-4e88244e] {\n    position: absolute;\n    right: 0px;\n    top: 3px;\n    display: block;\n}\n.faq-container .categoryAction i[data-v-4e88244e] {\n      font-size: 14px;\n      cursor: pointer;\n      color: \"[theme:themePrimary, default: #0078d4]\";\n      padding-right: 5px;\n}\n.faq-container .questionAction[data-v-4e88244e] {\n    position: absolute;\n    right: 0px;\n    top: 1px;\n    display: block;\n}\n.faq-container .questionAction i[data-v-4e88244e] {\n      font-size: 14px;\n      cursor: pointer;\n      color: \"[theme:themePrimary, default: #0078d4]\";\n      padding-right: 5px;\n}\n.faq-container .header-icon[data-v-4e88244e] {\n    font-size: 13px;\n    top: 1px;\n    color: \"[theme:themePrimary, default: #0078d4]\";\n}\n.faq-container .panel[data-v-4e88244e] {\n    margin-bottom: 0;\n}\n.faq-container .panel .panel-heading[data-v-4e88244e] {\n      padding: 0px;\n      position: relative;\n}\n.faq-container .panel .panel-heading .panel-title[data-v-4e88244e] {\n        margin-top: 0;\n        margin-bottom: 0;\n        font-size: 14px;\n        font-weight: 600;\n        padding-bottom: 10px;\n        border-bottom: 1px solid \"[theme:neutralLight, default:#eaeaea]\";\n}\n.faq-container .list-group[data-v-4e88244e] {\n    margin-top: 0;\n    border: 0;\n    padding-left: 0;\n    min-height: 20px;\n}\n.faq-container .list-group .list-group-item[data-v-4e88244e] {\n      border-bottom: 1px solid \"[theme:neutralLighter, default: #f4f4f4]\";\n      position: relative;\n      display: block;\n}\n.faq-container .list-group .list-group-item[data-v-4e88244e]:first-child {\n        border-top-width: 0;\n}\n.faq-container .list-group .list-group-item[data-v-4e88244e]:last-child {\n        margin-bottom: 0;\n        border-bottom: none;\n}\n.faq-container .question[data-v-4e88244e] {\n    position: relative;\n    padding-left: 0px;\n    padding-right: 0px;\n    cursor: pointer;\n    margin-bottom: 8px;\n    margin-top: 8px;\n}\n.faq-container .question .questionTextEdit[data-v-4e88244e] {\n      display: inline-block;\n      margin-left: 20px;\n      margin-right: 100px;\n}\n.faq-container .question .questionTextView[data-v-4e88244e] {\n      display: inline-block;\n      margin-left: 20px;\n      margin-right: 40px;\n}\n.faq-container .question .questionIcon[data-v-4e88244e] {\n      margin: 0px;\n      position: absolute;\n      top: 5px;\n      margin-left: -2px;\n}\n.faq-container .faqShowAllButton[data-v-4e88244e] {\n    cursor: pointer;\n    padding-bottom: 10px;\n}\n.faq-container .answer[data-v-4e88244e] {\n    overflow: hidden;\n}\n.faq-container .answer p[data-v-4e88244e] {\n      margin: 5px 0;\n}\n.faq-container a[data-v-4e88244e] {\n    text-decoration: none;\n}\n.faq-container .question-content[data-v-4e88244e] {\n    padding-left: 20px;\n    padding-bottom: 10px;\n}\n.faq-container .pagination[data-v-4e88244e] {\n    margin: 16px 0;\n}\n.faq-container .slide-down-enter[data-v-4e88244e] {\n    transform: translateY(-100%);\n}\n.faq-container .slide-down-enter-to[data-v-4e88244e] {\n    transform: translateY(0);\n}\n.faq-container .slide-down-leave[data-v-4e88244e] {\n    transform: translateY(0);\n}\n.faq-container .slide-down-leave-to[data-v-4e88244e] {\n    transform: translateY(-100%);\n}\n.faq-container .slide-down-enter-active[data-v-4e88244e],\n  .faq-container .slide-down-leave-active[data-v-4e88244e] {\n    transition: all 500ms ease-in-out;\n}\n.questionGhost[data-v-4e88244e],\n.categoryGhost[data-v-4e88244e] {\n  opacity: .5;\n}\n\n/*# sourceMappingURL=simple.vue.map */", map: {"version":3,"sources":["simple.vue"],"names":[],"mappings":"AAAA;EACE,iDAAiD;EACjD,iBAAiB;EACjB,kBAAkB;AAAE;AACpB;IACE,qBAAqB;IACrB,oBAAoB;AAAE;AACtB;MACE,kBAAkB;MAClB,QAAQ;MACR,iBAAiB;AAAE;AACrB;MACE,eAAe;AAAE;AACrB;IACE,kBAAkB;IAClB,UAAU;IACV,QAAQ;IACR,cAAc;AAAE;AAChB;MACE,eAAe;MACf,eAAe;MACf,+CAA+C;MAC/C,kBAAkB;AAAE;AACxB;IACE,kBAAkB;IAClB,UAAU;IACV,QAAQ;IACR,cAAc;AAAE;AAChB;MACE,eAAe;MACf,eAAe;MACf,+CAA+C;MAC/C,kBAAkB;AAAE;AACxB;IACE,eAAe;IACf,QAAQ;IACR,+CAA+C;AAAE;AACnD;IACE,gBAAgB;AAAE;AAClB;MACE,YAAY;MACZ,kBAAkB;AAAE;AACpB;QACE,aAAa;QACb,gBAAgB;QAChB,eAAe;QACf,gBAAgB;QAChB,oBAAoB;QACpB,gEAAgE;AAAE;AACxE;IACE,aAAa;IACb,SAAS;IACT,eAAe;IACf,gBAAgB;AAAE;AAClB;MACE,mEAAmE;MACnE,kBAAkB;MAClB,cAAc;AAAE;AAChB;QACE,mBAAmB;AAAE;AACvB;QACE,gBAAgB;QAChB,mBAAmB;AAAE;AAC3B;IACE,kBAAkB;IAClB,iBAAiB;IACjB,kBAAkB;IAClB,eAAe;IACf,kBAAkB;IAClB,eAAe;AAAE;AACjB;MACE,qBAAqB;MACrB,iBAAiB;MACjB,mBAAmB;AAAE;AACvB;MACE,qBAAqB;MACrB,iBAAiB;MACjB,kBAAkB;AAAE;AACtB;MACE,WAAW;MACX,kBAAkB;MAClB,QAAQ;MACR,iBAAiB;AAAE;AACvB;IACE,eAAe;IACf,oBAAoB;AAAE;AACxB;IACE,gBAAgB;AAAE;AAClB;MACE,aAAa;AAAE;AACnB;IACE,qBAAqB;AAAE;AACzB;IACE,kBAAkB;IAClB,oBAAoB;AAAE;AACxB;IACE,cAAc;AAAE;AAClB;IACE,4BAA4B;AAAE;AAChC;IACE,wBAAwB;AAAE;AAC5B;IACE,wBAAwB;AAAE;AAC5B;IACE,4BAA4B;AAAE;AAChC;;IAEE,iCAAiC;AAAE;AAEvC;;EAEE,WAAW;AAAE;;AAEf,qCAAqC","file":"simple.vue","sourcesContent":[".faq-container {\n  color: \"[theme:neutralPrimary, default: #333333]\";\n  padding-left: 0px;\n  padding-right: 0px; }\n  .faq-container .edit {\n    display: inline-block;\n    margin: 0px 0 15px 0; }\n    .faq-container .edit .ms-Icon {\n      position: relative;\n      top: 2px;\n      margin-right: 6px; }\n    .faq-container .edit .edit-item {\n      cursor: pointer; }\n  .faq-container .categoryAction {\n    position: absolute;\n    right: 0px;\n    top: 3px;\n    display: block; }\n    .faq-container .categoryAction i {\n      font-size: 14px;\n      cursor: pointer;\n      color: \"[theme:themePrimary, default: #0078d4]\";\n      padding-right: 5px; }\n  .faq-container .questionAction {\n    position: absolute;\n    right: 0px;\n    top: 1px;\n    display: block; }\n    .faq-container .questionAction i {\n      font-size: 14px;\n      cursor: pointer;\n      color: \"[theme:themePrimary, default: #0078d4]\";\n      padding-right: 5px; }\n  .faq-container .header-icon {\n    font-size: 13px;\n    top: 1px;\n    color: \"[theme:themePrimary, default: #0078d4]\"; }\n  .faq-container .panel {\n    margin-bottom: 0; }\n    .faq-container .panel .panel-heading {\n      padding: 0px;\n      position: relative; }\n      .faq-container .panel .panel-heading .panel-title {\n        margin-top: 0;\n        margin-bottom: 0;\n        font-size: 14px;\n        font-weight: 600;\n        padding-bottom: 10px;\n        border-bottom: 1px solid \"[theme:neutralLight, default:#eaeaea]\"; }\n  .faq-container .list-group {\n    margin-top: 0;\n    border: 0;\n    padding-left: 0;\n    min-height: 20px; }\n    .faq-container .list-group .list-group-item {\n      border-bottom: 1px solid \"[theme:neutralLighter, default: #f4f4f4]\";\n      position: relative;\n      display: block; }\n      .faq-container .list-group .list-group-item:first-child {\n        border-top-width: 0; }\n      .faq-container .list-group .list-group-item:last-child {\n        margin-bottom: 0;\n        border-bottom: none; }\n  .faq-container .question {\n    position: relative;\n    padding-left: 0px;\n    padding-right: 0px;\n    cursor: pointer;\n    margin-bottom: 8px;\n    margin-top: 8px; }\n    .faq-container .question .questionTextEdit {\n      display: inline-block;\n      margin-left: 20px;\n      margin-right: 100px; }\n    .faq-container .question .questionTextView {\n      display: inline-block;\n      margin-left: 20px;\n      margin-right: 40px; }\n    .faq-container .question .questionIcon {\n      margin: 0px;\n      position: absolute;\n      top: 5px;\n      margin-left: -2px; }\n  .faq-container .faqShowAllButton {\n    cursor: pointer;\n    padding-bottom: 10px; }\n  .faq-container .answer {\n    overflow: hidden; }\n    .faq-container .answer p {\n      margin: 5px 0; }\n  .faq-container a {\n    text-decoration: none; }\n  .faq-container .question-content {\n    padding-left: 20px;\n    padding-bottom: 10px; }\n  .faq-container .pagination {\n    margin: 16px 0; }\n  .faq-container .slide-down-enter {\n    transform: translateY(-100%); }\n  .faq-container .slide-down-enter-to {\n    transform: translateY(0); }\n  .faq-container .slide-down-leave {\n    transform: translateY(0); }\n  .faq-container .slide-down-leave-to {\n    transform: translateY(-100%); }\n  .faq-container .slide-down-enter-active,\n  .faq-container .slide-down-leave-active {\n    transition: all 500ms ease-in-out; }\n\n.questionGhost,\n.categoryGhost {\n  opacity: .5; }\n\n/*# sourceMappingURL=simple.vue.map */"]}, media: undefined });

  };
  /* scoped */
  const __vue_scope_id__ = "data-v-4e88244e";
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = false;
  /* component normalizer */
  function __vue_normalize__(
    template, style, script,
    scope, functional, moduleIdentifier,
    createInjector, createInjectorSSR
  ) {
    const component = (typeof script === 'function' ? script.options : script) || {};

    // For security concerns, we use only base name in production mode.
    component.__file = "C:\\agents\\agent2\\_work\\141\\s\\src\\webparts\\faq\\templates\\simple.vue";

    if (!component.render) {
      component.render = template.render;
      component.staticRenderFns = template.staticRenderFns;
      component._compiled = true;

      if (functional) component.functional = true;
    }

    component._scopeId = scope;

    {
      let hook;
      if (style) {
        hook = function(context) {
          style.call(this, createInjector(context));
        };
      }

      if (hook !== undefined) {
        if (component.functional) {
          // register for functional component in vue file
          const originalRender = component.render;
          component.render = function renderWithStyleInjection(h, context) {
            hook.call(context);
            return originalRender(h, context)
          };
        } else {
          // inject component registration as beforeCreate hook
          const existing = component.beforeCreate;
          component.beforeCreate = existing ? [].concat(existing, hook) : [hook];
        }
      }
    }

    return component
  }
  /* style inject */
  function __vue_create_injector__() {
    const head = document.head || document.getElementsByTagName('head')[0];
    const styles = __vue_create_injector__.styles || (__vue_create_injector__.styles = {});
    const isOldIE =
      typeof navigator !== 'undefined' &&
      /msie [6-9]\\b/.test(navigator.userAgent.toLowerCase());

    return function addStyle(id, css) {
      if (document.querySelector('style[data-vue-ssr-id~="' + id + '"]')) return // SSR styles are present.

      const group = isOldIE ? css.media || 'default' : id;
      const style = styles[group] || (styles[group] = { ids: [], parts: [], element: undefined });

      if (!style.ids.includes(id)) {
        let code = css.source;
        let index = style.ids.length;

        style.ids.push(id);

        if (isOldIE) {
          style.element = style.element || document.querySelector('style[data-group=' + group + ']');
        }

        if (!style.element) {
          const el = style.element = document.createElement('style');
          el.type = 'text/css';

          if (css.media) el.setAttribute('media', css.media);
          if (isOldIE) {
            el.setAttribute('data-group', group);
            el.setAttribute('data-next-index', '0');
          }

          head.appendChild(el);
        }

        if (isOldIE) {
          index = parseInt(style.element.getAttribute('data-next-index'));
          style.element.setAttribute('data-next-index', index + 1);
        }

        if (style.element.styleSheet) {
          style.parts.push(code);
          style.element.styleSheet.cssText = style.parts
            .filter(Boolean)
            .join('\n');
        } else {
          const textNode = document.createTextNode(code);
          const nodes = style.element.childNodes;
          if (nodes[index]) style.element.removeChild(nodes[index]);
          if (nodes.length) style.element.insertBefore(textNode, nodes[index]);
          else style.element.appendChild(textNode);
        }
      }
    }
  }
  /* style inject SSR */
  

  
  var simple = __vue_normalize__(
    { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    __vue_create_injector__);

export default simple;
